#ifndef OURDREAM_2D_PARTICLESYSTEM_H_INCLUDE
#define OURDREAM_2D_PARTICLESYSTEM_H_INCLUDE

#include "ComDef.h"
#include "IInterface.h"
#include "RenderSystem.h"

// ״̬
enum EParticleState
{
	EPS_UNKNOW=1,
	EPS_ALIVE=2,
	EPS_DEAD=3,
	EPS_DELETE=4
};

// ϵͳϢ
struct SParticleSystemInfo
{
	int m_iID;
	int m_iTexture;
	SOD2DFloatRect m_sTextureCoord;
	EParticleState m_eState;

	float m_fLifeTime;
	int m_iEmission;
	int m_iMaxParticles;
	float m_fX, m_fY;
	int m_iBlend;

	float m_fDirection;
	float m_fSpread;
	bool m_bRelative;

	float m_fMinParticleLife;
	float m_fMaxParticleLife;

	float m_fMinParticleVelocity;
	float m_fMaxParticleVelocity;

	float m_fMinParticlePower;
	float m_fMaxParticlePower;

	float m_fMinParticleGravity;
	float m_fMaxParticleGravity;

	float m_fMinParticleSize;
	float m_fMaxParticleSize;

	float m_fMinParticleSizeDelta;
	float m_fMaxParticleSizeDelta;

	float m_fSpinStart;
	float m_fSpinEnd;
	float m_fSpinVal;

	DWORD m_dStartColor;
	DWORD m_dEndColor;
	float m_fColorVal;
	float m_fAlphaVal;
};
// ϵͳ
class IParticleSystem : public IInterface
{
public:
	virtual bool CALL Init(IRenderSystem * render, SOD2DSystemSetup enginesetup)=0;
	virtual bool CALL Setup(SParticleSystemInfo setup)=0;
	virtual void CALL Reset(void)=0;
	virtual void CALL Release(void)=0;
	virtual void CALL CreateParticle(void)=0;
	virtual void CALL UpDate(float fdeltatime)=0;
	virtual void CALL Start(void)=0;
	virtual void CALL Stop(bool killallparticles=false)=0;

	virtual bool CALL RenderAll(void)=0;

	virtual void CALL KillAll(void)=0;
	virtual void CALL ClearAll(void)=0;
	virtual void CALL RemoveAllDeadParticles(void)=0;

	virtual bool CALL IsEmpty(void)=0;
	virtual bool CALL IsDead(void)=0;
	virtual bool CALL IsAllParticlesDead(void)=0;

	virtual SParticleSystemInfo CALL GetParticleSystemSetup(void)=0;

	virtual void CALL SetParticleMaxCount(int count)=0;
	virtual int CALL GetParticleMaxCount(void)=0;
	virtual int CALL GetParticleCurCount(void)=0;
	virtual void CALL GetParticleSystemPosition(float *x, float *y)=0;
	virtual void CALL SetParticleSystemAge(float age)=0;
	virtual float CALL GetParticleSystemAge(void)=0;
	virtual float CALL GetParticleSystemCurAge(void)=0;

	virtual void CALL MoveTo(float x, float y, bool moveallparticles)=0;

};

#endif